package com.example.standard.funkplotter;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.widget.ImageView;

public class PlotterView extends ImageView {
    private  Paint pinselGelb;
    private  Paint pinselRot;

    public PlotterView(Context context) {
        super(context);

        this.setBackgroundColor(Color.BLACK);

        //  Paint-Objekt für Gelb und
        // Linienbreite von 2 Pixeln erzeugen
        pinselGelb = new Paint();
        pinselGelb.setColor(Color.YELLOW);
        pinselGelb.setStrokeWidth(2);

        // Paint-Objekt für Rot und
        // Linienbreite von 2 Pixeln erzeugen
        pinselRot = new Paint();
        pinselRot.setColor(Color.RED);
        pinselRot.setStrokeWidth(2);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int breite = getWidth();
        int hoehe = getHeight();

        // Koordinatenachsen zeichnen (0-Punkt = Bildschirmmitte)
        canvas.drawLine(0, hoehe/2, breite, hoehe/2, pinselRot);
        canvas.drawLine(breite/2, 0, breite/2, hoehe, pinselRot);

        // 0-Punkt in die Mitte legen
        canvas.translate(breite/2, hoehe/2);


        // Werte zeichnen
        float skalier_x = breite / 10;
        float skalier_y = hoehe / 10;

        for(float x = -5; x <= 5; x+= 0.01) {
            double y = Math.sin(x); // x * x;

            int xpos = (int) (x * skalier_x);
            int ypos = -1 * (int) (y * skalier_y);
            canvas.drawPoint(xpos, ypos, pinselGelb);
        }
    }
}






