package com.example.standard.pintester;

import android.app.Activity;
import android.os.Handler;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.text.InputType;
import android.view.Gravity;
import android.view.Menu;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity implements View.OnClickListener, Runnable {

        private Handler handler;


        @Override
        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            setContentView(R.layout.activity_main);

            Button testButton = (Button) this.findViewById(R.id.button);
            testButton.setOnClickListener(this);

            EditText edit = (EditText)this.findViewById(R.id.editText);
            edit.setInputType(InputType.TYPE_CLASS_NUMBER );
            handler = new Handler();
        }



        public void onClick(View v) {
            Thread t = new Thread(this);
            t.start();

        }

        public void run() {
            EditText editView = (EditText) this.findViewById(R.id.editText);
            String text = editView.getText().toString();

            int pin = Integer.valueOf(text);

            final long start = System.currentTimeMillis();


            // PIN testen
            int test = 0;

            while(true) {
                if(pin == test) {
                    break;
                }
                else {
                    test++;
                }
            }


            // toast anzeigen
            final long ende = System.currentTimeMillis();


            handler.post(new Runnable() {
                public void run() {
                    String text = "Zeitbedarf : " + ( ende - start) + " ms";
                    Toast toast = Toast.makeText(MainActivity.this, text, Toast.LENGTH_LONG);
                    toast.setGravity(Gravity.CENTER|Gravity.LEFT, 0, 0);
                    toast.show();

                }
            });


        }
}
