package com.example.standard.startbrowser;

import android.content.Intent;
import android.net.Uri;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;

public class MainActivity extends AppCompatActivity implements View.OnClickListener {

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        Button button = (Button) this.findViewById(R.id.button);
        button.setOnClickListener(this);


    }



    public void onClick(View v) {
        // URL auslesen und Browser starten
        EditText editText = (EditText) this.findViewById(R.id.editText);

        String url = editText.getText().toString().trim();

        // sicherstellen, dass URL mit http:// oder https:// beginnt
        if( !url.startsWith("http://") || !url.startsWith("https://")) {
            url = "http://" + url;
        }


        Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
        startActivity(intent);
    }


}
