package com.example.standard.reaktionsapp;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;

public class MainActivity extends AppCompatActivity implements View.OnClickListener {

	public static String ROT_GRUEN_IGNORIEREN = "rotGrünIgnorieren";
	public static String WARTEZEIT = "warteZeit"; 
	public static String BESTZEIT = "bestZeit";

	private ReaktionstestView view;
	
	private Button startButton;
	private  Button endeButton; 
	private  Button einstellungenButton;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
        setContentView(R.layout.activity_main);
        
        // UI vervollständigen
        view = new ReaktionstestView(this); 
        LinearLayout verticalLayout = (LinearLayout) findViewById(R.id.linearLayout0);
        verticalLayout.addView(view);
        
        startButton =(Button) findViewById(R.id.button1);
        startButton.setOnClickListener(this);
        
        endeButton =(Button) findViewById(R.id.button2);
        endeButton.setOnClickListener(this);
 	   
	    einstellungenButton = (Button) findViewById(R.id.button3);
	    einstellungenButton.setOnClickListener(this);   
    }
    
	
	public void onClick(View v) {
		if(v == startButton) { // Reaktionstest starten 
			new Thread(view).start();
		}
		else if(v == endeButton) {
			// Programm beenden
			finish();
		}
		else if(v == einstellungenButton) { 
			// Activity für Auswahl der Einstellungen aufrufen
			Intent intent = new Intent(this, ReaktionstestEinstellungen.class);
			this.startActivityForResult(intent, 0);
		}
	}


	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		// die Einstellungen-Activity ist beendet worden; neue Einstellungen übernehmen
		if(resultCode == Activity.RESULT_OK) {
    	   Bundle daten = data.getExtras();
		   boolean rotGruenIgnorieren = daten.getBoolean(ROT_GRUEN_IGNORIEREN);
		   float warteZeit = daten.getFloat(WARTEZEIT);
			
		   // Einstellungen speichern
		   einstellungenSpeichern(rotGruenIgnorieren, warteZeit);
		}
	}
    
    	
	/**
	 * Die übergebenenen Parameter in den Preferences speichern 
	 * @param rotGruenIgnorieren
	 * @param warteZeit: in Sekunden
	 */
	private void einstellungenSpeichern(boolean rotGruenIgnorieren, float warteZeit) {
		SharedPreferences prefs = getPreferences(Context.MODE_PRIVATE);
		SharedPreferences.Editor editor = prefs.edit();
		editor.putBoolean(ROT_GRUEN_IGNORIEREN, rotGruenIgnorieren);
		editor.putFloat(WARTEZEIT, warteZeit); 
		editor.commit();
	}

}
