package com.example.standard.quizapp;

import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Button;
import java.util.HashMap;
import java.util.Map;

public class MainActivity extends AppCompatActivity implements View.OnClickListener {
    private SpielLogik spiel;
    private Map<Button, Integer> buttonAntwort;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // Spiellogik instanziieren
        spiel = new SpielLogik(this);

        // Antwort-Buttons mit Ereignislistener verbinden
        buttonAntwort = new HashMap<>();
        int[] buttonIDs = new int[]{R.id.antwortA, R.id.antwortB, R.id.antwortC, R.id.antwortD};
        int antwortNr = 1;

        for(int id : buttonIDs) {
            Button btn = (Button) this.findViewById(id);
            btn.setOnClickListener(this);
            buttonAntwort.put(btn, antwortNr); // merken welcher button zu welcher Antwortnummer gehört
            antwortNr++;
        }

        // 1. Frage laden
        Frage ersteFrage = spiel.fragen[0];
        ersteFrage.anzeigen(this);
    }

    public void onClick(View v) {
        int antwortNum = buttonAntwort.get(v);
        spiel.auswerten(antwortNum, this);
    }

}
