package com.example.standard.quizapp;
import android.content.Context;
import android.graphics.Color;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SpielLogik {
   Frage[] fragen;
   byte aktFrage = 0;
   Context context;

   public SpielLogik(Context c) {
       context = c;

      // Fragen erzeugen
       List<Frage> fragenListe = new ArrayList<>();

       try {
           InputStream is  = context.getResources().openRawResource(R.raw.fragen);
           BufferedReader br = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));

           while(true) {
               String str = br.readLine();

               if(str == null) {
                   break; // Ende erreicht
               }
               else {
                   StringTokenizer st = new StringTokenizer(str, "#");
                   String frage = st.nextToken().trim();
                   String antwort1 = st.nextToken().trim();
                   String antwort2 = st.nextToken().trim();
                   String antwort3 = st.nextToken().trim();
                   String antwort4 = st.nextToken().trim();
                   String loesung  = st.nextToken().trim();
                   int loesungNum  = Integer.valueOf(loesung);

                   Frage f = new Frage(frage, antwort1, antwort2, antwort3, antwort4, loesungNum);
                   fragenListe.add(f);
               }
           }
       }
       catch(Exception ex) {
           Log.d("MeineApp", ex.getMessage());
       }

       fragen = fragenListe.toArray(new Frage[fragenListe.size()]);


   }

   void auswerten(int antwortNummer, AppCompatActivity quizActivity) {

      if (!fragen[aktFrage].richtig(antwortNummer)) {  // falsch beantwortet
         if (aktFrage == 0) {
        	 Toast.makeText(quizActivity, "Leider direkt gescheitert! Spiel ist zu Ende.", Toast.LENGTH_LONG).show();
         }
         else {
            String fragen = aktFrage == 0 ? " Frage" : " Fragen"  ;
     	 	String str = "Sie haben " + (aktFrage+1) + fragen + " in Folge richtig beantwortet! Glückwunsch!";
    	 	Toast.makeText(quizActivity, str, Toast.LENGTH_LONG).show();
         }

         // Restart-Button zeigen
          restartButtonZeigen(quizActivity);
      } else {
         aktFrage++;
         Toast.makeText(quizActivity, "Richtig!", Toast.LENGTH_SHORT).show();

    	 if (aktFrage < fragen.length) {
             // weiter mit der nächsten Frage
             updateFortschritt(quizActivity);
             fragen[aktFrage].anzeigen(quizActivity);
         }
      	 else { // Ende erreicht
      		String str = "Super, Sie haben alles richtig beantwortet!!!";
      		Toast.makeText(quizActivity, str, Toast.LENGTH_LONG).show();

            // Restart-Button zeigen
            restartButtonZeigen(quizActivity);
         }
      }
   }

    private void updateFortschritt(AppCompatActivity quiz) {
        ProgressBar pb = (ProgressBar) quiz.findViewById(R.id.progressBar);
        pb.setProgress(aktFrage + 1);
        TextView text = (TextView) quiz.findViewById(R.id.text_progress);
        text.setText("Frage " + (aktFrage + 1) + " von " + fragen.length);
    }

    private void restartButtonZeigen(final AppCompatActivity quiz) {
        // Buttons deaktivieren
        buttonsAktivieren(quiz, false);

        final LinearLayout layout = (LinearLayout) quiz.findViewById(R.id.toplevel);
        final Button neuStart = new Button(quiz);
        neuStart.setBackgroundColor(Color.argb(255, 201, 86, 255));
        ViewGroup.LayoutParams params = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT,
                                                                       LinearLayout.LayoutParams.WRAP_CONTENT);
        neuStart.setLayoutParams(params);
        neuStart.setText("Hier klicken für Neustart");
        layout.addView(neuStart);
        neuStart.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                buttonsAktivieren(quiz, true);
                layout.removeView(neuStart);
                aktFrage = 0;
                updateFortschritt(quiz);
                fragen[aktFrage].anzeigen(quiz);
            }
        });
    }

    private void buttonsAktivieren(AppCompatActivity quiz, boolean aktiviert) {
        quiz.findViewById(R.id.antwortA).setEnabled(aktiviert);
        quiz.findViewById(R.id.antwortB).setEnabled(aktiviert);
        quiz.findViewById(R.id.antwortC).setEnabled(aktiviert);
        quiz.findViewById(R.id.antwortD).setEnabled(aktiviert);
    }
}