package com.example.standard.video;

import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.provider.MediaStore;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Gravity;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity implements View.OnClickListener {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        Button b = (Button) this.findViewById(R.id.button);
        b.setOnClickListener(this);
    }


    @Override
    public void onClick(View v) {
        Intent intent = new Intent(MediaStore.ACTION_VIDEO_CAPTURE);
        startActivityForResult(intent, 0);
    }

    @Override
    protected void onActivityResult(int requestCode,
                                    int resultCode, Intent data) {
        // falls die Kamera-App die Orientierung geändert hat,
        // wieder zurücksetzen
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);

        if(requestCode == 0 && data.getData() != null) {
            String url =  data.getData().toString();
            Toast toast = Toast.makeText(this, "Aufnahme in: " + url, Toast.LENGTH_LONG);
            toast.setGravity(Gravity.CENTER, 0 , 0);
            toast.show();
        }
    }
}
