package com.standard.example.senkblei;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.view.View;


public class LotAnzeige extends View {

    private Paint schwarz;
    private Paint pfeilPaint;
    private Bitmap pfeil;
    private Matrix pfeilMatrix;
    private int winkel;

    public LotAnzeige(Context c) {
        super(c);
        schwarz = new Paint();
        schwarz.setColor(Color.BLACK);

        pfeilPaint = new Paint(Paint.ANTI_ALIAS_FLAG | Paint.DITHER_FLAG | Paint.FILTER_BITMAP_FLAG);
        Resources resources = getResources();
        pfeil = BitmapFactory.decodeResource(resources, R.drawable.pfeil);

        pfeilMatrix  = new Matrix();
        winkel = 0;
    }


    public void update(int neuerWinkel) {
        winkel = neuerWinkel;
        invalidate();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        int w = canvas.getWidth();
        int h = canvas.getHeight();
        canvas.drawRect(0,0, w, h, schwarz);

        pfeilMatrix.postTranslate(-pfeil.getWidth() / 2, -pfeil.getHeight() / 2);
        pfeilMatrix.postRotate(winkel);
        pfeilMatrix.postTranslate(w/2, h/2);
        canvas.drawBitmap(pfeil, pfeilMatrix, pfeilPaint);
        pfeilMatrix.reset();
    }
}
