package com.standard.example.senkblei;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.RelativeLayout;

public class MainActivity extends AppCompatActivity implements SensorEventListener {
    private SensorManager sensorManager;
    private Sensor beschleunigungsSensor;
    private float gx, gy;
    private LotAnzeige lotAnzeige;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        gx = 0;
        gy = 0;

        sensorManager          = (SensorManager) getSystemService(Context.SENSOR_SERVICE);

        // am liebsten ein Gravity-Sensor
        beschleunigungsSensor = sensorManager.getDefaultSensor(Sensor.TYPE_GRAVITY);

        if(beschleunigungsSensor == null) { // fallback
            beschleunigungsSensor = sensorManager.getDefaultSensor(Sensor.TYPE_ACCELEROMETER);
        }

        RelativeLayout layout = (RelativeLayout) findViewById(R.id.relativeLayout);
        lotAnzeige = new LotAnzeige(this);
        layout.addView(lotAnzeige);
    }


    @Override
    public void onSensorChanged(SensorEvent event) {
        float[] werte = event.values.clone();


        if(beschleunigungsSensor.getType() == Sensor.TYPE_ACCELEROMETER) {
            // Gravitation herausfiltern
            final float faktor = 0.8f;

            gx = faktor * gx + (1 - faktor) * werte[0];
            gy = faktor * gy + (1 - faktor) * werte[1];
        }
        else { // Gravitationsfilter: werte ungefiltert nehmen
            gx = werte[0];
            gy = werte[1];
        }

        double g = Math.sqrt(gy * gy + gx * gx);
        double cos_a = Math.abs(gy / g);
        double alpha = Math.toDegrees(Math.acos(cos_a));
        int winkel   =  (int) (Math.signum(gx) * alpha * 100) / 100;

        lotAnzeige.update(winkel);
    }

    @Override
    public void onAccuracyChanged(Sensor sensor, int accuracy) {    }


    @Override
    protected void onPause() {
        super.onPause();
        sensorManager.unregisterListener(this);
    }


    @Override
    protected void onResume() {
        super.onResume();
        sensorManager.registerListener(this, beschleunigungsSensor, SensorManager.SENSOR_DELAY_UI);
    }
}
