package com.example.standard.zufallszahlen;

 import android.content.ContentValues;
 import android.content.Context;
 import android.database.Cursor;
 import android.database.sqlite.SQLiteDatabase;
 import android.database.sqlite.SQLiteOpenHelper;
 import android.util.Log;

public class DBZugriff extends SQLiteOpenHelper {

    private SQLiteDatabase db;


    /**
     * Konstruktor
     * @param activity: aufrufende Activity
     */
    public DBZugriff(Context activity) {
        super(activity, "Zufallszahlen", null, 1);

        db = this.getWritableDatabase();
        db.execSQL("DROP TABLE IF EXISTS daten" );
        onCreate(db);
    }



    @Override
    public void onCreate(SQLiteDatabase db) {
        try {
            String sql = "CREATE TABLE daten (_id INTEGER PRIMARY KEY AUTOINCREMENT, " +
                    "zufallszahl REAL NOT NULL)";


            db.execSQL(sql);
        }
        catch(Exception ex) {
            Log.e("MeineApp", ex.getMessage());
        }
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL("DROP TABLE IF EXISTS daten" );
        onCreate(db);
    }


    /**
     * Hier noch evtl. eigene Aufräumarbeiten durchführen
     */
    @Override
    public synchronized void close() {
        if(db != null) {
            db.close();
            db = null;
        }

        super.close();
    }



    public boolean zahlSpeichern(double zahl) {
        try {
            ContentValues daten = new ContentValues();
            daten.put("zufallszahl", zahl);
            db.insert("daten", null, daten);
            return true;
        }
        catch(Exception ex) {
            Log.d("MeineApp", ex.getMessage());
            return false;
        }
    }



    public Cursor erzeugeCursor() {
        return db.query("daten",  null, null, null, null, null, null);
    }






}

