package com.example.standard.zufallszahlen;

import android.content.Context;
import android.database.Cursor;
import android.os.Handler;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity implements View.OnClickListener, Runnable {

    private DBZugriff dbZugriff;
    private Handler handler;
    private Button startButton;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        startButton = (Button) this.findViewById(R.id.button);
        startButton.setOnClickListener(this);

        dbZugriff = new DBZugriff(this);
        handler   = new Handler();
    }

    @Override
    public void onClick(View arg0) {
        Button b = (Button) this.findViewById(R.id.button);
        b.setEnabled(false);

        Thread t = new Thread(this);
        t.start(); // als Hintergrundprozess starten
    }

    @Override
    public void run() {
        // Daten erzeugen und speichern
        for(int i = 0; i < 1000; i++) {
            double zufallszahl = Math.random();
            dbZugriff.zahlSpeichern(zufallszahl);
        }

        // jetzt Daten wieder auslesen und Mittelwert bilden
        double summe = 0;
        Cursor cursor = null;

        try {
            cursor = dbZugriff.erzeugeCursor();
            cursor.moveToFirst();

            boolean weiter = true;

            while(weiter) {
                summe += cursor.getDouble(1);
                weiter = cursor.moveToNext();
            }

            cursor.close();

            final double mittelwert = summe / 1000;

            final Context context = this;

            handler.post(new Runnable() {
                public void run() {
                    String text = "Mittelwert: " + mittelwert;
                    Toast toast = Toast.makeText(context, text, Toast.LENGTH_LONG);
                    toast.setGravity(Gravity.CENTER, 0, 0);
                    toast.show();
                    startButton.setEnabled(true);
                }
            });

        }
        catch(Exception ex) {
            Log.e("MeineApp", ex.getMessage());
        }
        finally {
            // egal ob Erfolg oder Exception:: cursor schließen
            if(cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }

    }




}