package com.example.standard.gpsmassband;

import android.Manifest;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity implements LocationListener, View.OnClickListener {

    private Button startButton;
    private Button stopButton;
    private LocationManager locationManager;

    private Location startPos;
    private TextView entfernungAnzeige;
    private TextView koordinaten;
    private boolean gpsTracking;

    private CharSequence textKoordinaten;
    private CharSequence textEntfernung;

    private float  aktDistanz = 0;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        startButton = (Button) this.findViewById(R.id.buttonStart);
        startButton.setOnClickListener(this);
        stopButton = (Button) this.findViewById(R.id.buttonStop);
        stopButton.setEnabled(false);
        stopButton.setOnClickListener(this);

        entfernungAnzeige = (TextView) this.findViewById(R.id.textViewEntfernung);
        koordinaten = (TextView) this.findViewById(R.id.textViewKoordinaten);
        locationManager = (LocationManager) this.getSystemService(Context.LOCATION_SERVICE);

        textKoordinaten = this.getResources().getText(R.string.koordinaten);
        textEntfernung = this.getResources().getText(R.string.entfernung);

        // Testen, ob GPS verfügbar
        if (!locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER)) {
            warnungUndBeenden();
        }


        startPos = null;
        gpsTracking = false;

    }


    public void onClick(View v) {
        if (v == startButton) {
            int permissionCheck = ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION);

            if(permissionCheck != PackageManager.PERMISSION_GRANTED) {
                ActivityCompat.requestPermissions(this, new String[]{Manifest.permission.ACCESS_FINE_LOCATION, Manifest.permission.WRITE_EXTERNAL_STORAGE}, 1);
                return;
            }

            aktDistanz = 0;
            startButton.setEnabled(false);
            stopButton.setEnabled(true);
            entfernungAnzeige.setText(textEntfernung + " 0");
            gpsTracking = true;
        }

        if (v == stopButton) {
            startButton.setEnabled(true);
            stopButton.setEnabled(false);

            gpsTracking = false;
            startPos = null;
            String str = String.valueOf(aktDistanz);
            entfernungAnzeige.setText(textEntfernung + " " + str);
        }

    }


    @Override
    protected void onPause() {
        super.onPause();

        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED ) {
            locationManager.removeUpdates(this);
        }

    }

    @Override
    public void onRequestPermissionsResult(int requestCode,
                                           String permissions[], int[] grantResults) throws SecurityException{
        if(grantResults[0] == PackageManager.PERMISSION_GRANTED) {
            locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, 500, 0, this);
        }

    }


    @Override
    protected void onResume() {
        super.onResume();

        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED) {
            locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, 500, 0, this);
        }

    }


    @Override
    public void onLocationChanged(Location location) {

        Toast toast = Toast.makeText(this, "Location " + location, Toast.LENGTH_SHORT);
        toast.show();

        koordinaten.setText(textKoordinaten + " " +  location.getLatitude() + ", " + location.getLongitude());


        if( !gpsTracking) {
            return;
        }

        if(startPos == null) {
            startPos = location;
        }


        aktDistanz = location.distanceTo(startPos);
        String str = String.valueOf(aktDistanz);
        entfernungAnzeige.setText(textEntfernung + " " + str + " m");
    }


    public void onProviderDisabled(String provider) {
        // TODO Auto-generated method stub

    }


    public void onProviderEnabled(String provider) {
        // TODO Auto-generated method stub

    }


    public void onStatusChanged(String provider, int status, Bundle extras) {
        // TODO Auto-generated method stub

    }

    /** Benutzer auffordern GPS zu aktivieren und Activity beenden
     *
     */
    private void warnungUndBeenden() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        Resources res = getResources();
        String text   = res.getString(R.string.keinGPS);
        builder.setMessage(text);
        builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                dialog.dismiss();
                finish(); // Activity beenden
            }
        });
        AlertDialog dialog = builder.create();
        dialog.show();
    }

}
